#include <bits/stdc++.h>

using namespace std;

bool checkSymbol(char c) {
    return ('a' <= c && c <= 'z') || c == '<' || c == '>' || c == '/';
}

bool hasLetter(string s) {
    for (char i : s) {
        if ('a' <= i && i <= 'z') {
            return true;
        }
    }
}

bool check(string s) {
    if (!hasLetter(s)) {
        return false;
    }
    stack<string> st;
    for (char i : s) {
        if (!checkSymbol(i)) {
            return false;
        }
    }
    bool isBracket = false;
    string bracket;
    for (char i : s) {
        if (i == '<') {
            if (isBracket) {
                return false;
            }
            isBracket = true;
        } else if (i == '>') {
            if (!isBracket || bracket.empty()) {
                return false;
            }
            if (bracket[0] == '/') {
                if (st.empty() || st.top() != bracket.substr(1, bracket.size() - 1)) {
                    return false;
                }
                st.pop();
            } else {
                st.push(bracket);
            }
            bracket.clear();
            isBracket = false;
        } else {
            if (!isBracket) {
                return false;
            }
            if (!bracket.empty() && i == '/') {
                return false;
            }
            bracket += i;
        }
    }
    return st.empty() && !isBracket;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    string s;
    cin >> s;
    cout << (check(s) ? "Yes\n" : "No\n") << '\n';
    return 0;
}
